<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (
        empty($data["Rules1"]) &&
        empty($data["Rules2"]) &&
        empty($data["Rules3"]) &&
        empty($data["Rules4"]) &&
        empty($data["Rules5"]) &&
        empty($data["Rules6"])
    ) {
        echo json_encode([
            "status" => "error",
            "message" => "At least one rule is required"
        ]);
        exit;
    }

    $Rules1 = trim($data["Rules1"] ?? "");
    $Rules2 = trim($data["Rules2"] ?? "");
    $Rules3 = trim($data["Rules3"] ?? "");
    $Rules4 = trim($data["Rules4"] ?? "");
    $Rules5 = trim($data["Rules5"] ?? "");
    $Rules6 = trim($data["Rules6"] ?? "");

    $sql = "INSERT INTO `rules` (`id`, `Rules1`, `Rules2`, `Rules3`, `Rules4`, `Rules5`, `Rules6`)
            VALUES (1, ?, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                `Rules1` = VALUES(`Rules1`),
                `Rules2` = VALUES(`Rules2`),
                `Rules3` = VALUES(`Rules3`),
                `Rules4` = VALUES(`Rules4`),
                `Rules5` = VALUES(`Rules5`),
                `Rules6` = VALUES(`Rules6`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssss", $Rules1, $Rules2, $Rules3, $Rules4, $Rules5, $Rules6);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Rules updated successfully"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed"
        ]);
    }

    $stmt->close();
}
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `rules` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status" => "success",
            "Rules1" => $row["Rules1"],
            "Rules2" => $row["Rules2"],
            "Rules3" => $row["Rules3"],
            "Rules4" => $row["Rules4"],
            "Rules5" => $row["Rules5"],
            "Rules6" => $row["Rules6"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No data found"
        ]);
    }
}

$conn->close();
?>